# OTP System - Testing & Verification Guide

## 🧪 Complete Testing Checklist

### Before You Start
- [ ] Ensure XAMPP is running (Apache + MySQL)
- [ ] Database `cleaning_service` exists
- [ ] Gmail account credentials are correct
- [ ] Internet connection is active

---

## 1️⃣ Step 1: Verify System is Working

### Open Test Page
```
URL: http://localhost/Cleaning%20Service/test_otp_system.php
```

### What to Check
- [ ] Page loads without errors
- [ ] All tests show ✓ (green checkmarks)
- [ ] Configuration constants displayed
- [ ] Database connection successful
- [ ] OTP table mentioned

### Expected Results
```
✓ Test 1: Configuration Constants - PASSED
✓ Test 2: OTPHandler Class Methods - PASSED
✓ Test 3: Database Connection - PASSED
✓ Test 4: Required Files - PASSED
```

### If Something Fails
1. Check PHP error logs: `C:\xampp\apache\logs\error.log`
2. Verify database connection in config.php
3. Check email credentials are correct
4. Ensure all files are in correct location

---

## 2️⃣ Step 2: Test Registration with OTP

### Scenario: New User Registration

**Test 1: Form Submission**
1. Go to: `http://localhost/Cleaning%20Service/register.php`
2. Fill in form:
   ```
   Full Name: John Test User
   Email: your-test-email@gmail.com
   Phone: +1234567890
   Password: TestPass123
   Confirm: TestPass123
   ```
3. Click "Continue to Verification"

**Expected Result**:
- [ ] No validation errors
- [ ] OTP sent message appears
- [ ] Redirected to Step 2 (OTP entry)
- [ ] Shows countdown timer starting from 10:00

**Test 2: Email Delivery**
1. Check your email inbox
2. Look for email from: Cleaning Service

**Expected Email**:
- [ ] Email received within 30 seconds
- [ ] Subject: "Email Verification - Your OTP Code"
- [ ] Green header with company name
- [ ] Large OTP code displayed
- [ ] Timer showing 10-minute expiry

**Test 3: OTP Entry**
1. Copy OTP code from email (6 digits)
2. Go back to browser
3. Paste OTP code into input field

**Expected Input Behavior**:
- [ ] Only numbers accepted
- [ ] Auto-formats as you type
- [ ] Maximum 6 characters
- [ ] Can paste full code

**Test 4: OTP Verification**
1. Click "Verify & Complete Registration"

**Expected Result**:
- [ ] Success message: "Registration successful!"
- [ ] Redirected to login page after 2 seconds
- [ ] Can login with email and password

**Test 5: Try Invalid OTP**
1. Go back to register.php
2. Fill form again with different email
3. Submit and get OTP
4. Intentionally enter WRONG OTP (e.g., 000000)
5. Click "Verify & Complete Registration"

**Expected Result**:
- [ ] Error message: "Invalid or expired OTP"
- [ ] Stay on verification page
- [ ] Can resend OTP

**Test 6: Resend OTP**
1. Click "Didn't receive OTP? Resend"

**Expected Result**:
- [ ] Success message: "OTP resent to your email!"
- [ ] New email received with new OTP
- [ ] New OTP is different from previous one
- [ ] Can use new OTP to verify

**Test 7: Expired OTP**
1. Get OTP and enter it (don't verify immediately)
2. Wait 10 minutes (or until countdown reaches 0:00)
3. Try to enter same OTP

**Expected Result**:
- [ ] Error message: "Invalid or expired OTP"
- [ ] Must resend to get new OTP

---

## 3️⃣ Step 3: Test Password Reset with OTP

### Scenario: User Forgot Password

**Test 1: Forgot Password Page**
1. Go to: `http://localhost/Cleaning%20Service/login.php`
2. Click "Forgot Password?" link

**Expected Result**:
- [ ] Redirected to forgot_password.php
- [ ] Orange themed page
- [ ] Email input field

**Test 2: Send OTP**
1. Enter email of existing user (or one from registration test)
2. Click "Send OTP"

**Expected Result**:
- [ ] Success message: "OTP has been sent to your email!"
- [ ] Redirected to reset_password.php
- [ ] Step 1 (OTP verification) shown

**Test 3: Email Delivery**
1. Check email inbox

**Expected Email**:
- [ ] Email received within 30 seconds
- [ ] Subject: "Password Reset - Your OTP Code"
- [ ] Orange header
- [ ] Large OTP code displayed
- [ ] Security warning included

**Test 4: OTP Verification**
1. Copy OTP from email
2. Paste into OTP field on reset_password.php
3. Click "Verify OTP"

**Expected Result**:
- [ ] Success message: "OTP verified!"
- [ ] Redirect to Step 2
- [ ] New password form shown

**Test 5: New Password Entry**
1. Enter new password:
   ```
   New Password: NewPass456
   Confirm Password: NewPass456
   ```
2. Click "Reset Password"

**Expected Result**:
- [ ] Success message: "Password reset successfully!"
- [ ] Redirected to login page
- [ ] Can login with new password

**Test 6: Verify New Password Works**
1. Go to login.php
2. Enter email and new password
3. Click "Login"

**Expected Result**:
- [ ] Login successful
- [ ] Redirected to dashboard/home page
- [ ] Session set correctly

**Test 7: Old Password Doesn't Work**
1. Go to login.php
2. Enter email and old password
3. Click "Login"

**Expected Result**:
- [ ] Error message: "Invalid email or password"
- [ ] Cannot login

---

## 4️⃣ Step 4: Test Edge Cases

### Test 1: Non-existent Email on Forgot Password
1. Go to forgot_password.php
2. Enter fake email (not in database)
3. Click "Send OTP"

**Expected Result**:
- [ ] Error message: "Email not found in our system"
- [ ] No OTP sent
- [ ] Stay on same page

### Test 2: Duplicate Email on Registration
1. Try to register with email already in database
2. Fill form with existing email
3. Click "Continue to Verification"

**Expected Result**:
- [ ] Error message: "Email is already registered"
- [ ] No OTP sent
- [ ] Stay on registration form

### Test 3: Invalid Email Format
1. Try to register with invalid email (e.g., "notanemail")
2. Fill form with invalid email
3. Click "Continue to Verification"

**Expected Result**:
- [ ] Error message: "Invalid email format"
- [ ] No OTP sent
- [ ] Stay on registration form

### Test 4: Password Too Short
1. Try to register with short password (e.g., "123")
2. Fill form with short password
3. Click "Continue to Verification"

**Expected Result**:
- [ ] Error message: "Password must be at least 6 characters"
- [ ] No OTP sent
- [ ] Stay on registration form

### Test 5: Passwords Don't Match
1. Try to register with mismatched passwords
2. Password: "Test123"
3. Confirm: "Test124"
4. Click "Continue to Verification"

**Expected Result**:
- [ ] Error message: "Passwords do not match"
- [ ] No OTP sent
- [ ] Stay on registration form

### Test 6: Missing Required Fields
1. Try to submit form with empty fields
2. Clear one field at a time
3. Click "Continue to Verification"

**Expected Result**:
- [ ] HTML5 validation: "Please fill out this field"
- [ ] Cannot submit with empty fields

---

## 5️⃣ Step 5: Test Mobile Responsiveness

### Test on Different Devices
1. Desktop browser
   - [ ] Full width layout
   - [ ] Proper spacing
   - [ ] Large buttons

2. Tablet (iPad size)
   - [ ] Adjusted layout
   - [ ] Touch-friendly buttons
   - [ ] Readable text

3. Mobile phone (iPhone size)
   - [ ] Single column layout
   - [ ] Large buttons for touch
   - [ ] Readable on small screen
   - [ ] OTP input easy to use

### Using Browser DevTools
1. Open Chrome DevTools (F12)
2. Click device toggle (mobile icon)
3. Test different screen sizes:
   - [ ] 320px (small phone)
   - [ ] 768px (tablet)
   - [ ] 1200px (desktop)

---

## 6️⃣ Step 6: Test Email Features

### Email Template Quality
- [ ] Professional HTML layout
- [ ] Proper branding (company name, colors)
- [ ] Clear OTP display (large font)
- [ ] Expiry time shown
- [ ] Security information included
- [ ] Proper formatting
- [ ] Links work (if any)

### Email Delivery
- [ ] Emails arrive in inbox (not spam)
- [ ] Delivery time < 30 seconds
- [ ] All information visible
- [ ] Mobile-friendly display
- [ ] Dark mode compatible

---

## 7️⃣ Step 7: Test Database Operations

### Check OTP Table Creation
1. Open phpMyAdmin
2. Go to database: `cleaning_service`
3. Look for table: `otp_verifications`

**Expected Table**:
- [ ] Table exists
- [ ] Columns: id, email, otp, type, created_at, expires_at, verified
- [ ] Proper data types

### Check OTP Records
1. Open phpMyAdmin
2. Click on `otp_verifications` table
3. Look at records

**Expected Records**:
- [ ] Contains test OTP entries
- [ ] email field populated
- [ ] otp field populated (6 digits)
- [ ] type field shows 'registration' or 'password_reset'
- [ ] expires_at shows future timestamp
- [ ] verified shows 0 (unused) or 1 (used)

### Check Users Table
1. Open phpMyAdmin
2. Click on `users` table
3. Look for test accounts

**Expected Records**:
- [ ] New users from tests present
- [ ] Email correct
- [ ] Name correct
- [ ] Password hashed (not plain text)
- [ ] Status is 'active'

---

## 8️⃣ Step 8: Test Security Features

### Test SQL Injection Prevention
1. Try common SQL injection attempts in email field:
   ```
   test@example.com' OR '1'='1
   admin@example.com'; DROP TABLE users; --
   ```

**Expected Result**:
- [ ] All attempts treated as normal email
- [ ] Validation error shown
- [ ] No database damage
- [ ] Application continues working

### Test Password Hashing
1. Register new account
2. Open phpMyAdmin
3. Check user's password field

**Expected Result**:
- [ ] Password is hashed (long string starting with $2y$)
- [ ] Not readable
- [ ] Cannot see actual password

### Test Session Security
1. Register account
2. Open browser DevTools (F12)
3. Go to Application → Cookies

**Expected Result**:
- [ ] Session cookie created
- [ ] Contains session ID (not user data)
- [ ] HttpOnly flag set (if visible)

---

## 9️⃣ Step 9: Stress Testing

### Test Multiple OTPs
1. Request OTP 5 times in a row (resend button)
2. Check that new OTP is generated each time
3. Old OTPs should be deleted

**Expected Result**:
- [ ] Each OTP is unique
- [ ] Only latest OTP works
- [ ] Old codes don't work
- [ ] No errors

### Test Session Cleanup
1. Register account (don't complete OTP)
2. Close browser completely
3. Open browser again
4. Try to verify previous OTP

**Expected Result**:
- [ ] Redirected to forgot_password.php
- [ ] Previous session cleared
- [ ] Cannot use old OTP

### Test Long OTP Code Entry
1. Paste 10-digit code into OTP field
2. Observe behavior

**Expected Result**:
- [ ] Only first 6 digits accepted
- [ ] Remaining digits ignored
- [ ] Auto-limits input

---

## 🔟 Step 10: Error Logging & Debugging

### Check Error Logs
1. Open: `C:\xampp\apache\logs\error.log`
2. Look for entries from your tests

**Expected**:
- [ ] Log file exists
- [ ] Contains expected PHP entries
- [ ] No critical errors
- [ ] OTP operations logged if enabled

### Check Database Logs (Optional)
1. Check MySQL error log (if available)
2. Verify no SQL errors

**Expected**:
- [ ] No syntax errors
- [ ] Tables created successfully
- [ ] Queries executed properly

---

## Final Verification Checklist

### Registration
- [x] Form validation works
- [x] OTP generated and sent
- [x] User receives email
- [x] OTP verification works
- [x] Account created
- [x] Can login with new account
- [x] Invalid OTP rejected
- [x] Resend OTP works
- [x] Expired OTP rejected

### Password Reset
- [x] Form validation works
- [x] OTP generated and sent
- [x] User receives email
- [x] OTP verification works
- [x] Password update works
- [x] Can login with new password
- [x] Old password doesn't work
- [x] Invalid OTP rejected
- [x] Resend OTP works

### UI/UX
- [x] Professional design
- [x] Clear error messages
- [x] Countdown timer works
- [x] Auto-format OTP input
- [x] Mobile responsive
- [x] Easy to understand

### Security
- [x] SQL injection prevented
- [x] Passwords hashed
- [x] Sessions managed properly
- [x] OTP one-time use enforced
- [x] Email validation works
- [x] Expiry checking works

### Database
- [x] Table auto-created
- [x] Data stored correctly
- [x] Data cleaned up properly
- [x] No orphaned records

---

## 🎉 Success Criteria

**System is ready for production when ALL of the following are true:**

✅ test_otp_system.php - All tests PASS
✅ Registration with OTP - Complete success
✅ Password Reset with OTP - Complete success
✅ Emails delivered - Within 30 seconds
✅ Mobile responsive - Works on all devices
✅ Security checks - All pass
✅ Database operations - All correct
✅ Error handling - Proper messages shown
✅ No console errors - Chrome DevTools clean
✅ No PHP errors - Error log clean

---

## 📝 Test Report Template

```
Date: ___________
Tester: ___________

Registration Tests:
  [✓/✗] Form submission
  [✓/✗] OTP generation
  [✓/✗] Email delivery
  [✓/✗] OTP verification
  [✓/✗] Account creation

Password Reset Tests:
  [✓/✗] Email entry
  [✓/✗] OTP generation
  [✓/✗] Email delivery
  [✓/✗] OTP verification
  [✓/✗] Password update

Security Tests:
  [✓/✗] Input validation
  [✓/✗] SQL injection prevention
  [✓/✗] Password hashing
  [✓/✗] Session management

Overall Status: [ ] PASS [ ] FAIL

Issues Found:
_________________________________
_________________________________

Notes:
_________________________________
_________________________________
```

---

**When all tests pass, the system is ready for production deployment!** 🚀
